/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.rules.logic;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.rules.Condition;
import com.izforge.izpack.api.rules.ConditionWithMultipleOperands;
import com.izforge.izpack.api.rules.RulesEngine;

public class AndCondition
extends ConditionWithMultipleOperands {
    private static final long serialVersionUID = -5854944262991488370L;
    protected transient RulesEngine rules;

    public AndCondition(RulesEngine rules) {
        this.rules = rules;
    }

    @Override
    public void readFromXML(IXMLElement xmlcondition) throws Exception {
        if (xmlcondition.getChildrenCount() <= 0) {
            throw new Exception("Missing nested element in condition \"" + this.getId() + "\"");
        }
        for (IXMLElement element : xmlcondition.getChildren()) {
            this.nestedConditions.add(this.rules.createCondition(element));
        }
    }

    @Override
    public boolean isTrue() {
        boolean result = true;
        for (Condition condition : this.nestedConditions) {
            result = result && condition.isTrue();
        }
        return result;
    }

    @Override
    public String getDependenciesDetails() {
        StringBuffer details = new StringBuffer();
        details.append(this.getId());
        details.append(" depends on:<ul><li>");
        for (Condition condition : this.nestedConditions) {
            details.append(condition.getDependenciesDetails());
            details.append("</li> AND <li>");
        }
        details.append("</li></ul>");
        return details.toString();
    }

    @Override
    public void makeXMLData(IXMLElement conditionRoot) {
        for (Condition condition : this.nestedConditions) {
            IXMLElement left = this.rules.createConditionElement(condition, conditionRoot);
            condition.makeXMLData(left);
            conditionRoot.addChild(left);
        }
    }
}

