/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.rules.process;

import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.Variables;
import com.izforge.izpack.api.rules.CompareCondition;
import com.izforge.izpack.api.rules.ComparisonOperator;
import java.util.logging.Logger;

public class CompareNumericsCondition
extends CompareCondition {
    private static final long serialVersionUID = -5512232923336878003L;
    private static final transient Logger logger = Logger.getLogger(CompareNumericsCondition.class.getName());

    @Override
    public boolean isTrue() {
        boolean result = false;
        AutomatedInstallData installData = this.getInstallData();
        if (installData != null && this.operand1 != null && this.operand2 != null) {
            Variables variables = installData.getVariables();
            String arg1 = variables.replace(this.operand1);
            String arg2 = variables.replace(this.operand2);
            if (this.operator == null) {
                this.operator = ComparisonOperator.EQUAL;
            }
            try {
                int leftValue = Integer.valueOf(arg1);
                int rightValue = Integer.valueOf(arg2);
                switch (this.operator) {
                    case EQUAL: {
                        result = leftValue == rightValue;
                        break;
                    }
                    case NOTEQUAL: {
                        result = leftValue != rightValue;
                        break;
                    }
                    case GREATER: {
                        result = leftValue > rightValue;
                        break;
                    }
                    case GREATEREQUAL: {
                        result = leftValue >= rightValue;
                        break;
                    }
                    case LESS: {
                        result = leftValue < rightValue;
                        break;
                    }
                    case LESSEQUAL: {
                        result = leftValue <= rightValue;
                        break;
                    }
                }
            }
            catch (NumberFormatException nfe) {
                logger.warning("One of the values to compare is not in numeric format");
            }
        }
        return result;
    }
}

