/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.variable;

import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.Value;
import com.izforge.izpack.api.regex.RegularExpressionFilter;
import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.core.regex.RegularExpressionProcessorImpl;

public abstract class ValueImpl
implements Value {
    private AutomatedInstallData installData;

    @Override
    public abstract void validate() throws Exception;

    @Override
    public abstract String resolve() throws Exception;

    @Override
    public abstract String resolve(VariableSubstitutor ... var1) throws Exception;

    @Override
    public String resolve(RegularExpressionFilter regexp, VariableSubstitutor ... substitutors) throws Exception {
        String newValue = this.resolve(substitutors);
        if (regexp != null) {
            String replace = null;
            String select = null;
            String regex = null;
            for (VariableSubstitutor substitutor : substitutors) {
                replace = substitutor.substitute(regexp.getReplace());
            }
            for (VariableSubstitutor substitutor : substitutors) {
                select = substitutor.substitute(regexp.getSelect());
            }
            for (VariableSubstitutor substitutor : substitutors) {
                regex = substitutor.substitute(regexp.getRegexp());
            }
            RegularExpressionProcessorImpl processor = new RegularExpressionProcessorImpl();
            processor.setInput(newValue);
            processor.setRegexp(regex);
            processor.setCaseSensitive(regexp.getCasesensitive());
            if (select != null) {
                processor.setSelect(select);
            } else if (replace != null) {
                processor.setReplace(replace);
                processor.setGlobal(regexp.getGlobal());
            }
            newValue = processor.execute();
        }
        return newValue;
    }

    @Override
    public AutomatedInstallData getInstallData() {
        return this.installData;
    }

    @Override
    public void setInstallData(AutomatedInstallData installData) {
        this.installData = installData;
    }
}

