/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.event;

import com.izforge.izpack.api.exception.NativeLibException;
import com.izforge.izpack.api.exception.WrappedNativeLibException;
import com.izforge.izpack.api.handler.AbstractUIProgressHandler;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.core.os.RegistryDefaultHandler;
import com.izforge.izpack.core.os.RegistryHandler;
import com.izforge.izpack.event.NativeUninstallerListener;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.List;

public class RegistryUninstallerListener
extends NativeUninstallerListener {
    private final RegistryDefaultHandler handler;
    private final Messages messages;

    public RegistryUninstallerListener(RegistryDefaultHandler handler, Messages messages) {
        this.handler = handler;
        this.messages = messages;
    }

    @Override
    public void beforeDeletion(List files, AbstractUIProgressHandler handler) throws Exception {
        InputStream in = this.getClass().getResourceAsStream("/registryEntries");
        if (in == null) {
            return;
        }
        ObjectInputStream objIn = new ObjectInputStream(in);
        List allActions = (List)objIn.readObject();
        objIn.close();
        in.close();
        if (allActions == null || allActions.size() < 1) {
            return;
        }
        try {
            RegistryHandler registryHandler = this.handler.getInstance();
            if (registryHandler == null) {
                return;
            }
            registryHandler.activateLogging();
            registryHandler.setLoggingInfo(allActions);
            registryHandler.rewind();
        }
        catch (NativeLibException e) {
            throw new WrappedNativeLibException(e, this.messages);
        }
    }
}

