/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.gui;

import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.installer.base.InstallDataConfiguratorWithRules;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.installer.manager.PanelManager;

public class InstallerController {
    private InstallerFrame installerFrame;
    private PanelManager panelManager;
    private AutomatedInstallData automatedInstallData;

    public InstallerController(PanelManager panelManager, InstallDataConfiguratorWithRules installDataRulesEngineManager, InstallerFrame installerFrame, AutomatedInstallData automatedInstallData) {
        this.panelManager = panelManager;
        this.installerFrame = installerFrame;
        this.automatedInstallData = automatedInstallData;
        installDataRulesEngineManager.configureInstallData();
    }

    public InstallerController preloadInstaller() throws ClassNotFoundException {
        return this;
    }

    public InstallerController buildInstallation() throws Exception {
        this.panelManager.createPanels();
        this.installerFrame.buildGUI();
        this.installerFrame.sizeFrame();
        return this;
    }

    public void launchInstallation() {
        this.activateFirstPanel();
    }

    private void activateFirstPanel() {
        int firstPanel = this.installerFrame.hasNavigateNext(-1, false);
        if (firstPanel > -1) {
            this.installerFrame.setVisible(true);
            this.automatedInstallData.setCurPanelNumber(firstPanel);
            this.installerFrame.switchPanel(firstPanel);
        }
    }
}

