/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.unpacker;

import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.data.ParsableFile;
import com.izforge.izpack.util.OsConstraintHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class ScriptParser {
    private VariableSubstitutor replacer;

    public ScriptParser(VariableSubstitutor replacer) {
        this.replacer = replacer;
    }

    public void parse(ParsableFile parsable) throws Exception {
        if (!OsConstraintHelper.oneMatchesCurrentSystem(parsable.osConstraints)) {
            return;
        }
        File file = new File(parsable.path);
        File parsedFile = File.createTempFile("izpp", null, file.getParentFile());
        FileInputStream inFile = new FileInputStream(file);
        BufferedInputStream in = new BufferedInputStream(inFile, 5120);
        FileOutputStream outFile = new FileOutputStream(parsedFile);
        BufferedOutputStream out = new BufferedOutputStream(outFile, 5120);
        this.replacer.substitute(in, out, parsable.type, parsable.encoding);
        in.close();
        out.close();
        if (!file.delete()) {
            throw new IOException("Failed to delete file: " + file);
        }
        if (!parsedFile.renameTo(file)) {
            throw new IOException("Could not rename file " + parsedFile + " to " + file);
        }
    }
}

