/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.processorclient;

import com.izforge.izpack.gui.FlowLayout;
import com.izforge.izpack.panels.userinput.processorclient.ProcessingClient;
import com.izforge.izpack.panels.userinput.validator.Validator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class TextInputField
extends JComponent
implements ProcessingClient {
    private static final long serialVersionUID = 8611515659787697087L;
    private static final transient Logger logger = Logger.getLogger(TextInputField.class.getName());
    private Map<String, String> validatorParams;
    private Validator validationService;
    private JTextField field;
    private boolean hasParams = false;

    public TextInputField(String set, int size, String validator, Map<String, String> validatorParams) {
        this(set, size, validator);
        this.validatorParams = validatorParams;
        this.hasParams = true;
    }

    public TextInputField(String set, int size, String validator) {
        try {
            if (validator != null) {
                logger.fine("Making Validator for: " + validator);
                this.validationService = (Validator)Class.forName(validator).newInstance();
            }
        }
        catch (Throwable e) {
            this.validationService = null;
            logger.log(Level.WARNING, e.toString(), e);
        }
        FlowLayout layout = new FlowLayout();
        layout.setAlignment(3);
        layout.setVgap(0);
        this.setLayout(layout);
        this.field = new JTextField(set, size);
        this.field.setCaretPosition(0);
        this.add(this.field);
    }

    @Override
    public Map<String, String> getValidatorParams() {
        return this.validatorParams;
    }

    @Override
    public String getText() {
        return this.field.getText();
    }

    public void setText(String value) {
        this.field.setText(value);
    }

    @Override
    public String getFieldContents(int index) {
        return this.field.getText();
    }

    @Override
    public int getNumFields() {
        return 1;
    }

    public boolean validateContents() {
        if (this.validationService != null) {
            logger.fine("Validating contents");
            return this.validationService.validate(this);
        }
        logger.fine("Not validating contents");
        return true;
    }

    @Override
    public boolean hasParams() {
        return this.hasParams;
    }
}

