/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.validator;

import com.izforge.izpack.panels.userinput.PasswordGroup;
import com.izforge.izpack.panels.userinput.processorclient.ProcessingClient;
import com.izforge.izpack.panels.userinput.validator.Validator;
import com.izforge.izpack.util.Base64;
import java.security.SecureRandom;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;

public class PasswordEncryptionValidator
implements Validator {
    private static final Logger logger = Logger.getLogger(PasswordEncryptionValidator.class.getName());
    private Cipher encryptCipher;

    @Override
    public boolean validate(ProcessingClient client) {
        boolean returnValue = true;
        String encryptedPassword = null;
        String key = null;
        String algorithm = null;
        Map<String, String> params = this.getParams(client);
        try {
            key = params.get("encryptionKey");
            algorithm = params.get("algorithm");
            if (key != null && algorithm != null) {
                this.initialize(key, algorithm);
                encryptedPassword = this.encryptString(client.getFieldContents(0));
                if (encryptedPassword != null) {
                    PasswordGroup group = (PasswordGroup)client;
                    group.setModifiedPassword(encryptedPassword);
                } else {
                    returnValue = false;
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Password encryption failed: " + e, e);
            returnValue = false;
        }
        return returnValue;
    }

    private Map<String, String> getParams(ProcessingClient client) {
        PasswordGroup group = null;
        Map<String, String> params = null;
        try {
            group = (PasswordGroup)client;
            if (group.hasParams()) {
                params = group.getValidatorParams();
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Getting validator parameters failed: " + e, e);
        }
        return params;
    }

    private void initialize(String key, String algorithm) throws Exception {
        try {
            KeyGenerator keygen = KeyGenerator.getInstance(algorithm);
            keygen.init(new SecureRandom(key.getBytes()));
            byte[] keyBytes = keygen.generateKey().getEncoded();
            SecretKeySpec specKey = new SecretKeySpec(keyBytes, algorithm);
            this.encryptCipher = Cipher.getInstance(algorithm);
            this.encryptCipher.init(1, specKey);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error initializing password encryption: " + e, e);
            throw e;
        }
    }

    public String encryptString(String string) throws Exception {
        String result = null;
        try {
            byte[] cryptedbytes = null;
            cryptedbytes = this.encryptCipher.doFinal(string.getBytes("UTF-8"));
            result = Base64.encodeBytes(cryptedbytes);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error encrypting string: " + e, e);
            throw e;
        }
        return result;
    }
}

