/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.config.base.spi;

import com.izforge.izpack.util.config.base.CommentedMap;
import com.izforge.izpack.util.config.base.Config;
import com.izforge.izpack.util.config.base.Profile;
import com.izforge.izpack.util.config.base.spi.IniHandler;

abstract class AbstractProfileBuilder
implements IniHandler {
    private Profile.Section _currentSection;
    private boolean _header;
    private String _lastComment;
    private int _emptyLines = 0;

    AbstractProfileBuilder() {
    }

    @Override
    public void endIni() {
        if (this._lastComment != null && this._header) {
            this.setHeaderComment();
        }
    }

    @Override
    public void endSection() {
        this._currentSection = null;
    }

    @Override
    public void handleComment(String comment) {
        if (this._lastComment != null && this._header) {
            this._header = false;
            this.setHeaderComment();
        }
        this._lastComment = comment;
    }

    @Override
    public void handleEmptyLine() {
        ++this._emptyLines;
    }

    @Override
    public void handleOption(String name, String value) {
        this._header = false;
        if (this.getConfig().isMultiOption()) {
            this._currentSection.add(name, value);
        } else {
            this._currentSection.put(name, value);
        }
        if (this._lastComment != null) {
            this.putComment(this._currentSection, name);
            this._lastComment = null;
        }
        if (this._emptyLines > 0) {
            this.putEmptyLines(this._currentSection, name);
            this._emptyLines = 0;
        }
    }

    @Override
    public void startIni() {
        if (this.getConfig().isHeaderComment()) {
            this._header = true;
        }
    }

    @Override
    public void startSection(String sectionName) {
        if (this.getConfig().isMultiSection()) {
            this._currentSection = this.getProfile().add(sectionName);
        } else {
            Profile.Section s = (Profile.Section)this.getProfile().get(sectionName);
            Profile.Section section = this._currentSection = s == null ? this.getProfile().add(sectionName) : s;
        }
        if (this._lastComment != null) {
            if (this._header) {
                this.setHeaderComment();
            } else {
                this.putComment(this.getProfile(), sectionName);
            }
            this._lastComment = null;
        }
        if (this._emptyLines > 0) {
            if (!this._header) {
                this.putEmptyLines(this.getProfile(), sectionName);
            }
            this._emptyLines = 0;
        }
        this._header = false;
    }

    abstract Config getConfig();

    abstract Profile getProfile();

    Profile.Section getCurrentSection() {
        return this._currentSection;
    }

    private void setHeaderComment() {
        if (this.getConfig().isComment()) {
            this.getProfile().setComment(this._lastComment);
        }
    }

    private void putComment(CommentedMap<String, ?> map, String key) {
        if (this.getConfig().isComment()) {
            map.putComment(key, this._lastComment);
        }
    }

    private void putEmptyLines(CommentedMap<String, ?> map, String key) {
        if (this.getConfig().isEmptyLines()) {
            for (int i = 0; i < this._emptyLines; ++i) {
                map.addEmptyLine(key);
            }
        }
    }
}

