/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.os;

import com.izforge.izpack.util.Librarian;
import com.izforge.izpack.util.os.WinSetupAPIBase;
import com.izforge.izpack.util.os.WinSetupQueueCallbackInterface;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;

public class WinSetupFileQueue
extends WinSetupAPIBase {
    private static final Logger logger = Logger.getLogger(WinSetupFileQueue.class.getName());
    private int reboot = 0;
    private int handle = -1;

    public WinSetupFileQueue(Librarian librarian) throws Exception {
        this(librarian, null);
    }

    public WinSetupFileQueue(Librarian librarian, WinSetupQueueCallbackInterface handler) throws Exception {
        super(librarian);
        this.handle = this.SetupOpenFileQueue(handler);
    }

    protected void addCopy(File sourcefile, File targetfile, int copyStyle) throws IOException {
        this.SetupQueueCopy(this.handle, sourcefile.getParent(), null, sourcefile.getName(), null, null, targetfile.getParent(), targetfile.getName(), copyStyle);
    }

    public void addCopy(File sourcefile, File targetfile) throws IOException {
        this.addCopy(sourcefile, targetfile, false);
    }

    public void addCopy(File sourcefile, File targetfile, boolean forceInUse) throws IOException {
        int style = 0;
        if (forceInUse) {
            style |= 0x200;
        }
        this.addCopy(sourcefile, targetfile, style);
    }

    public void addDelete(File file) throws IOException {
        this.SetupQueueDelete(this.handle, file.getParent(), file.getName());
    }

    public void addRename(File sourcefile, File targetfile) throws IOException {
        this.SetupQueueRename(this.handle, sourcefile.getParent(), sourcefile.getName(), targetfile.getParent(), targetfile.getName());
    }

    public void addMove(File sourcefile, File targetfile) throws IOException {
        this.addCopy(sourcefile, targetfile, false);
    }

    public void addMove(File sourcefile, File targetfile, boolean forceInUse) throws IOException {
        int style = 1;
        if (forceInUse) {
            style |= 0x200;
        }
        this.addCopy(sourcefile, targetfile, style);
    }

    public boolean commit() throws Exception {
        boolean result = this.SetupCommitFileQueue(this.handle);
        if (result) {
            this.reboot = this.SetupPromptReboot(this.handle, true);
            if ((this.reboot & 1) != 0) {
                logger.info("There are file operations pending");
            }
            if ((this.reboot & 2) != 0) {
                logger.info("System reboot is recommended");
            }
            if ((this.reboot & 4) != 0) {
                logger.info("System shutdown is already in progress");
            }
        }
        return result;
    }

    public void close() {
        this.SetupCloseFileQueue(this.handle);
        this.handle = -1;
    }

    public boolean isRebootNecessary() {
        return this.reboot > 0;
    }
}

